      SUBROUTINE DRFFTI(N,WSAVE)    
C***BEGIN PROLOGUE  DRFFTI
C***DATE WRITTEN   790601   (YYMMDD)    
C***REVISION DATE  860115   (YYMMDD)    
C***CATEGORY NO.  J1A1   
C***KEYWORDS  FOURIER TRANSFORM    
C***AUTHOR  SWARZTRAUBER, P. N., (NCAR) 
C***PURPOSE  Initialize for DRFFTF and DRFFTB. 
C***DESCRIPTION
C    
C           From the book, "Numerical Methods and Software" by
C                D. Kahaner, C. Moler, S. Nash
C                Prentice Hall, 1989
C    
C  Subroutine DRFFTI initializes the array WSAVE which is used in 
C  both DRFFTF and DRFFTB.  The prime factorization of N together with  
C  a tabulation of the trigonometric functions are computed and  
C  stored in WSAVE. 
C    
C  Input Parameter  
C    
C  N       the length of the sequence to be transformed.    
C    
C  Output Parameter 
C    
C  WSAVE   a DP work array which must be dimensioned at least 2*N+15.    
C          The same work array can be used for both DRFFTF and DRFFTB   
C          as long as N remains unchanged.  Different WSAVE arrays    
C          are required for different values of N.  The contents of   
C          WSAVE must not be changed between calls of DRFFTF or DRFFTB. 
C    
C  *********************************************************************   
C  *                                                                   *   
C  *   SUBPROGRAM REVISION HISTORY                                     *   
C  *                                                                   *   
C  *   06/01/79  -  Original version by Paul Swarztrauber.             *   
C  *                Distributed by NCAR (ref. 1).                      *   
C  *   04/01/83  -  SLATEC Common Math Library Subcommittee.           *   
C  *                Modified to use SLATEC library source file format. *   
C  *                Distributed in the SLATEC library (ref. 2).        *   
C  *   01/15/86  -  Ron Boisvert, National Bureau of Standards.        *   
C  *                Modified to convert to portable Fortran 77.        *   
C  *                                                                   *   
C  *   The changes introduced in the most recent modification are      *   
C  *                                                                   *   
C  *   (a) Dummy array size declarations (1) changed to (*)            *   
C  *   (b) References to intrinsic function FLOAT changed to DP        *   
C  *   (c) Mathematical constants previously coded in DATA state-      *   
C  *       ments now computed at runtime using Fortran intrinsic       *   
C  *       functions.  The affected variables are                      *   
C  *                                                                   *   
C  *          PI      SQRT2   SQRT3   TAUR    TR11    TR12             *   
C  *          PIH     TSQRT2          TAUI    TI11    TI12             *   
C  *          TPI     HSQT2                                            *   
C  *                                                                   *   
C  *   References                                                      *   
C  *                                                                   *   
C  *   1. P.N. Swarztrauber, Vectorizing the FFTs, in Parallel         *   
C  *      Computations (G. Rodrigue, ed.), Academic Press, 1982,       *   
C  *      pp. 51-83.                                                   *   
C  *   2. B.L. Buzbee, The SLATEC Common Math Library, in Sources      *   
C  *      and Development of Mathematical Software (W. Cowell, ed.),   *   
C  *      Prentice-Hall, 1984, pp. 302-318.                            *   
C  *                                                                   *   
C  *********************************************************************   
C    
C***REFERENCES  (NONE)   
C***ROUTINES CALLED  DRFTI1   
C***END PROLOGUE  DRFFTI  
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION       WSAVE(*)
C***FIRST EXECUTABLE STATEMENT  DRFFTI   
      IF (N .EQ. 1) RETURN    
      CALL DRFTI1 (N,WSAVE(N+1),WSAVE(2*N+1))
      RETURN   
      END 
